const portalService = require('../services/clientPortalService');
const paymentService = require('../services/paymentService');

exports.getDashboard = async (req, res) => {
    try {
        const data = await portalService.getClientDashboard(req.user.clientId);
        res.json(data);
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
};

exports.getInvoices = async (req, res) => {
    try {
        const data = await portalService.getClientInvoices(req.user.clientId);
        res.json(data);
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
};

exports.getQuotes = async (req, res) => {
    try {
        const data = await portalService.getClientQuotes(req.user.clientId);
        res.json(data);
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
};

exports.getPayments = async (req, res) => {
    try {
        const data = await paymentService.getClientPayments(req.user.clientId);
        res.json(data);
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
};

exports.recordPayment = async (req, res) => {
    try {
        // In a real system, verify the client owns the invoice
        const payment = await paymentService.recordPayment(req.body, req.user.id);
        res.status(201).json(payment);
    } catch (err) {
        res.status(400).json({ error: err.message });
    }
};
