const clientService = require('../services/clientService');

exports.getClients = async (req, res) => {
    try {
        const clients = await clientService.getAllClients();
        res.json(clients);
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
};

exports.getClient = async (req, res) => {
    try {
        const client = await clientService.getClientById(req.params.id);
        if (!client) return res.status(404).json({ message: 'Client not found' });
        res.json(client);
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
};

exports.createClient = async (req, res) => {
    try {
        const client = await clientService.createClient(req.body, req.user.id);
        res.status(201).json(client);
    } catch (err) {
        res.status(400).json({ error: err.message });
    }
};

exports.updateClient = async (req, res) => {
    try {
        const client = await clientService.updateClient(req.params.id, req.body, req.user.id);
        res.json(client);
    } catch (err) {
        res.status(400).json({ error: err.message });
    }
};

exports.deleteClient = async (req, res) => {
    try {
        await clientService.deleteClient(req.params.id, req.user.id);
        res.status(204).send();
    } catch (err) {
        res.status(400).json({ error: err.message });
    }
};
