const budgetService = require('../services/budgetService');

exports.setBudget = async (req, res) => {
    try {
        const budget = await budgetService.setBudget(req.body, req.user.id);
        res.json(budget);
    } catch (err) {
        res.status(400).json({ error: err.message });
    }
};

exports.getStatus = async (req, res) => {
    try {
        const { period } = req.query; // ?period=2024-01
        if (!period) return res.status(400).json({ error: 'Period is required' });

        const status = await budgetService.getBudgetStatus(period);
        res.json(status);
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
};

exports.deleteBudget = async (req, res) => {
    try {
        await budgetService.deleteBudget(req.params.id);
        res.json({ message: 'Budget deleted' });
    } catch (err) {
        res.status(400).json({ error: err.message });
    }
};
