const bankService = require('../services/bankService');

exports.createAccount = async (req, res) => {
    try {
        const account = await bankService.createBankAccount(req.body);
        res.status(201).json(account);
    } catch (err) {
        res.status(400).json({ error: err.message });
    }
};

exports.getAccounts = async (req, res) => {
    try {
        const accounts = await bankService.getBankAccounts();
        res.json(accounts);
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
};

exports.getTransactions = async (req, res) => {
    try {
        const transactions = await bankService.getAccountTransactions(req.params.id);
        res.json(transactions);
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
};

exports.setDefault = async (req, res) => {
    try {
        await bankService.setAsDefault(req.params.id);
        res.json({ message: 'Default bank account updated' });
    } catch (err) {
        res.status(400).json({ error: err.message });
    }
};
