# 🏦 Enterprise Income & Expense Management System

An in-house accounting platform built with Node.js, React, and MySQL. This version serves as the **Foundation Base System**.

## 🏗️ Modular Architecture

The system is designed to be pluggable. Each feature (Income, Expense, etc.) is a standalone module.

### Backend Structure
- `config/`: System and Database config.
- `models/`: Database schemas (Sequelize).
- `controllers/`: Request handling logic.
- `services/`: Business logic and external integrations (Email, Audit).
- `routes/`: API endpoint definitions.
- `middlewares/`: Auth (JWT) and logic guards.
- `utils/`: Reusable helpers (Loggers, Formatters).

### Frontend Structure
- `contexts/`: Global state (Auth).
- `layouts/`: Master pages (Sidebar + Topbar).
- `pages/`: View components and module shells.
- `components/`: Reusable UI atomics (StatCards, Tables).

---

## 🔐 Core Foundation implemented
1. **JWT & RBAC**: Roles (Super Admin, Finance, HR, Client) are enforced via route guards and API middleware.
2. **Audit Logging**: Every action is recorded in `AuditLogs` for compliance.
3. **Email System**: Global `emailService` for SMTP notifications.
4. **QuickBooks UI**: Sidebar-driven navigation with a modern fintech aesthetic.

---

## 🛠️ Next Development Steps (Modules)

| Order | Module | Status | TODO Markers |
|-------|--------|--------|--------------|
| 1 | **Income** | 📝 Planned | Implement `Income` model and Sales dashboard. |
| 2 | **Expenses** | 📝 Planned | Implement Category tracking and Receipt uploads. |
| 3 | **Invoices** | 📝 Planned | Implement PDF Generation and Emailing system. |
| 4 | **Quotes** | 📝 Planned | Implement Quote-to-Invoice conversion. |
| 5 | **Payroll** | 📝 Planned | Implement Employee salary management. |
| 6 | **Reports** | 📝 Planned | Implement P&L and Balance Sheet logic. |

---

## 🚀 Setup Instructions

1. **Environment**: Copy `backend/.env.example` to `backend/.env` and fill details.
2. **Database**: Import `database/foundation_schema.sql` into MySQL.
3. **Install**: Run `npm run install-all` from the root.
4. **Run**: Run `npm run dev` to start the foundation.

*Note: Default credentials for first login should be created via a seeding script or manually in the Users table.*
